
#include <dos.h>
#include <math.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <graphics.h>

#define ESC	0x1b			/* Define the escape key	*/
#define TRUE	1			/* Define some handy constants	*/
#define FALSE	0			/* Define some handy constants	*/
#define PI	3.14159 		/* Define a value for PI	*/
#define ON	1			/* Define some handy constants	*/
#define OFF	0			/* Define some handy constants	*/

#define NFONTS 11

struct points {
	int x,y,z;
	};
int NoPoints=10;
struct points point[]= { { 10, -10,  1 },
			{-18,  10, -1 },
			{ 15,   6,  1 },
			{-25, -15, -1 },
			{ 40,  30,  1 },
			{-10,  20, -1 },
			{ 50,  10,  1 },
			{-10,  50, -1 },
			{ 10,  60,  1 },
			{  3, -40, -1 }};

char *Fonts[NFONTS] = {
  "DefaultFont",   "TriplexFont",   "SmallFont",
  "SansSerifFont", "GothicFont", "ScriptFont", "SimplexFont", "TriplexScriptFont",
  "ComplexFont", "EuropeanFont", "BoldFont"
};

char *LineStyles[] = {
  "SolidLn",  "DottedLn",  "CenterLn",  "DashedLn",  "UserBitLn"
};

char *FillStyles[] = {
  "EmptyFill",  "SolidFill",      "LineFill",      "LtSlashFill",
  "SlashFill",  "BkSlashFill",    "LtBkSlashFill", "HatchFill",
  "XHatchFill", "InterleaveFill", "WideDotFill",   "CloseDotFill"
};

char *TextDirect[] = {
  "HorizDir",  "VertDir"
};

char *HorizJust[] = {
  "LeftText",   "CenterText",   "RightText"
};

char *VertJust[] = {
  "BottomText",  "CenterText",  "TopText"
};

int    GraphDriver;		/* The Graphics device driver		*/
int    GraphMode;		/* The Graphics mode value		*/
double AspectRatio;		/* Aspect ratio of a pixel on the screen*/
int    MaxX, MaxY;		/* The maximum resolution of the screen */
int    MaxColors;		/* The maximum # of colors available	*/
int    ErrorCode;		/* Reports any graphics errors		*/
struct palettetype palette;		/* Used to read palette info	*/

/*									*/
/*	Function prototypes						*/
/*									*/

void Initialize(void);
void TextDump(void);
void TextDemo(void);
void ThisWindow(char *header);
void StatusLine(char *msg);
void DrawBorder(void);
void changetextstyle(int font, int direction, int charsize);
int  gprintf(int *xloc, int *yloc, char *fmt, ... );
void Pause(void);
void makegraph(void);
void DrawAxis(void);
void GraphParm(int *height,int *width);
void Plot(float x,float y,char P);
void ShowPoints(void);
void ShowLine(float m,float b,int Put);
void Printlc(int l,int c,char *String,int Put);
void Grid(void);
void Fill(int d[4], int o[4]);

/*									*/
/*	Begin main function						*/
/*									*/
struct viewporttype vp;
/*
int main()
{
  int d[]={1,0,1,0},o[]={0,1,0,1};
  Initialize();
  ThisWindow("Neural Net Simulation");
  changetextstyle(1, HORIZ_DIR ,1 );
  getviewsettings( &vp );
  Grid();
  Fill(d,o);
  Pause();
  Fill(o,d);
  Pause();
  return(0);
}


/*									*/
/*	INITIALIZE: Initializes the graphics system and reports 	*/
/*	any errors which occured.					*/
/*									*/

void Initialize(void)
{
  int xasp, yasp;			/* Used to read the aspect ratio*/

  GraphDriver = DETECT; 		/* Request auto-detection	*/
  initgraph( &GraphDriver, &GraphMode, "" );
  ErrorCode = graphresult();		/* Read result of initialization*/
  if( ErrorCode != grOk ){		/* Error occured during init	*/
    printf(" Graphics System Error: %s\n", grapherrormsg( ErrorCode ) );
    exit( 1 );
  }

  getpalette( &palette );		/* Read the palette from board	*/
  MaxColors = getmaxcolor() + 1;	/* Read maximum number of colors*/

  MaxX = getmaxx();
  MaxY = getmaxy();			/* Read size of screen		*/

  getaspectratio( &xasp, &yasp );	/* read the hardware aspect	*/
  AspectRatio = (double)xasp / (double)yasp; /* Get correction factor	*/

}



/*									*/
/*	DRAWBORDER: Draw a solid single line around the current 	*/
/*	viewport.							*/
/*									*/

void DrawBorder(void)
{
  struct viewporttype vp;

  setcolor( MaxColors - 1 );		/* Set current color to white	*/

  setlinestyle( SOLID_LINE, 0, NORM_WIDTH );

  getviewsettings( &vp );
  rectangle( 0, 0, vp.right-vp.left, vp.bottom-vp.top );

}

/*									*/
/*	GPRINTF: Used like PRINTF except the output is sent to the	*/
/*	screen in graphics mode at the specified co-ordinate.		*/
/*									*/

int gprintf( int *xloc, int *yloc, char *fmt, ... )
{
  va_list  argptr;			/* Argument list pointer	*/
  char str[140];			/* Buffer to build sting into	*/
  int cnt;				/* Result of SPRINTF for return */

  va_start( argptr, fmt );		/* Initialize va_ functions	*/

  cnt = vsprintf( str, fmt, argptr );	/* prints string to buffer	*/
  outtextxy( *xloc, *yloc, str );	/* Send string in graphics mode */
  *yloc += textheight( "H" ) + 2;       /* Advance to next line         */

  va_end( argptr );			/* Close va_ functions		*/

  return( cnt );			/* Return the conversion count	*/

}
/*									*/
/*	PAUSE: Pause until the user enters a keystroke. If the		*/
/*	key is an ESC, then exit program, else simply return.		*/
/*									*/

void Pause(void)
{
  static char msg[] = "Esc aborts or press a key...";
  int c;

  StatusLine( msg );			/* Put msg at bottom of screen	*/

  c = getch();				/* Read a character from kbd	*/

  if( ESC == c ){			/* Does user wish to leave?	*/
    closegraph();			/* Change to text mode		*/
    exit( 1 );				/* Return to OS 		*/
  }

  if( 0 == c ){ 			/* Did use hit a non-ASCII key? */
    c = getch();			/* Read scan code for keyboard	*/
  }


}

/*									*/
/*	CHANGETEXTSTYLE: similar to settextstyle, but checks for	*/
/*	errors that might occur while loading the font file.		*/
/*									*/

void changetextstyle(int font, int direction, int charsize)
{
  int ErrorCode;

  graphresult();			/* clear error code		*/
  settextstyle(font, direction, charsize);
  ErrorCode = graphresult();		/* check result 		*/
  if( ErrorCode != grOk ){		/* if error occured		*/
    closegraph();
    printf(" Graphics System Error: %s\n", grapherrormsg( ErrorCode ) );
    exit( 1 );
  }
}


/*									*/
/*	MAINWINDOW: Establish the main window for the demo and set	*/
/*	a viewport for the demo code.					*/
/*									*/

void ThisWindow( char *header )
{
  int height,scrn_width;
  clearviewport();			/* Clear graphics viewport	*/
  setcolor( MaxColors - 1 );		/* Set current color to white	*/
  getviewsettings( &vp );  		// Save the current port settings


  height = textheight( "H" );           /* Get basic text height        */
  scrn_width=vp.right-vp.left;
  settextjustify( CENTER_TEXT, TOP_TEXT );
  outtextxy(scrn_width/2 , 0, header );
  setviewport( vp.left, vp.top+height+4, vp.right, vp.bottom-(height+4), 1 );
  DrawBorder();
  setviewport( vp.left+1,vp.top+height+5,vp.right-1, vp.bottom-(height+5), 1 );
  settextjustify( LEFT_TEXT, TOP_TEXT );
  getviewsettings( &vp );

}


/*									*/
/*	STATUSLINE: Display a status line at the bottom of the screen.	*/
/*									*/

void StatusLine( char *msg )
{
  int height;

  setviewport( 0, 0, MaxX, MaxY, 1 );	/* Open port to full screen	*/
  setcolor( MaxColors - 1 );		/* Set current color to white	*/

  changetextstyle( DEFAULT_FONT, HORIZ_DIR, 1 );
  settextjustify( CENTER_TEXT, TOP_TEXT );
  setlinestyle( SOLID_LINE, 0, NORM_WIDTH );
  setfillstyle( EMPTY_FILL, 0 );

  height = textheight( "H" );           /* Detemine current height      */
  bar( 0, MaxY-(height+4), MaxX, MaxY );
  rectangle( 0, MaxY-(height+4), MaxX, MaxY );
  outtextxy( MaxX/2, MaxY-(height+2), msg );
  setviewport( 1, height+5, MaxX-1, MaxY-(height+5), 1 );

}

struct viewporttype graph;

void makegraph()
{

  getviewsettings( &vp );  		// Save the current port settings

  setcolor( MaxColors - 1 );		/* Set current color to white	*/

  setlinestyle( SOLID_LINE, 0, NORM_WIDTH );
  /* create a smaller viewport */
  setviewport(   (vp.right-vp.left)/3, 30,
		 vp.right-10, (vp.bottom*2/3) , 1);

  changetextstyle(1, HORIZ_DIR ,1 );
  ThisWindow("Graph");
  getviewsettings(&graph );

  setviewport(vp.left,vp.top,vp.right,vp.bottom,vp.clip);
}

void DrawAxis()
{
	int height,width;

	GraphParm(&height,&width);
	clearviewport();
	line(10,height/2,width-10,height/2);
	line(width/2,10,width/2,height-10);
}
void GraphParm(int *height,int *width)
{
	// Get Height and Widht of the Graph Window

	setviewport(graph.left,graph.top,
		graph.right,graph.bottom,graph.clip);

	*width=graph.right-graph.left;
	*height=graph.bottom-graph.top;

}
void Plot(float x,float y,char P)
{
	// Plot the Character P to Screen at indicated point
	int height,width,xp,yp;
	char *p=" ";

	GraphParm(&height,&width);

	xp=(int)(width-20)/2*x/60+width/2;
	yp=(int)(height-20)/2*y/60*(-1)+height/2;
	p[0]=P;

	outtextxy(xp,yp,p);

}
void ShowPoints()
{       char *P="X O";
	int i;
	DrawAxis();
	changetextstyle(2,HORIZ_DIR,2);
	settextjustify(CENTER_TEXT,CENTER_TEXT);

	for (i=0 ; i< NoPoints ; i++)
		       Plot(point[i].x,point[i].y,P[point[i].z+1]);
	changetextstyle(1,HORIZ_DIR,1);
	settextjustify(LEFT_TEXT,TOP_TEXT);

}
void ShowLine(float m,float b,int Put)
{
	int height,width,x1,y1,x2,y2;
	float x,y;

	if(Put) setcolor( MaxColors - 1 );	       /* Set current color to white	*/
	  else  setcolor( getbkcolor() );
	GraphParm(&height,&width);
	x=60;
	for(;;)
	{       y=m*x+b;
		if (-60<y && y<60) break;
		x-=1;
	}
	x1=(int)(width-20)/2*x/60+width/2;
	y1=(int)(height-20)/2*y/60*(-1)+height/2;

	x=-60;
	for(;;)
	{       y=m*x+b;
		if (-60<y && y<60) break;
		x+=1;
	}

	x2=(int)(width-20)/2*x/60+width/2;
	y2=(int)(height-20)/2*y*(-1)/60+height/2;

	line(x1,y1,x2,y2);
	setcolor( MaxColors - 1 );
}
void Printlc(int l,int c,char *String,int Put)
{
	int lineh,charw;
	setviewport(vp.left,vp.top,vp.right,vp.bottom,vp.clip);
	changetextstyle(1,HORIZ_DIR,1);

	if(Put) setcolor( MaxColors - 1 );    /* Set current color to white	*/
	  else  setcolor( getbkcolor() );     /* Set Color to backround */
	settextjustify(LEFT_TEXT,TOP_TEXT);

	lineh=textheight("H");
	charw=textwidth("H");

	outtextxy(charw*c,lineh*l,String);
	setcolor( MaxColors - 1 );
}
int drop,xdist,box;
void Grid()
{
	drop=(vp.bottom-vp.top)/2;
	xdist=(vp.right-vp.left)/3;
	box=(vp.right-vp.left)/10;
	setlinestyle(SOLID_LINE,0,THICK_WIDTH);
	line(xdist,drop, 	box*4+xdist,drop);
	line(xdist,drop+box,  	box*4+xdist,drop+box);
	line(xdist,drop+box*2,  box*4+xdist,drop+box*2);

	line(xdist,drop,	xdist,drop+box*2);
	line(xdist+box,drop,	xdist+box,drop+box*2);
	line(xdist+box*2,drop,	xdist+box*2,drop+box*2);
	line(xdist+box*3,drop,	xdist+box*3,drop+box*2);
	line(xdist+box*4,drop,	xdist+box*4,drop+box*2);
}
void Fill(int d[4], int o[4])
{
	int i;
	for(i=0;i<4;i++)
	{
		if (d[i])
			setfillstyle(XHATCH_FILL,MaxColors-3);
		else
			setfillstyle(EMPTY_FILL,MaxColors-3);
		floodfill(xdist+box*i+box/2,drop+box/2,MaxColors-1);
	}
	for(i=0;i<4;i++)
	{
		if (o[i])
			setfillstyle(XHATCH_FILL,MaxColors-3);
		else
			setfillstyle(EMPTY_FILL,MaxColors-3);
		floodfill(xdist+box*i+box/2,drop+box*3/2,MaxColors-1);
	}
}